<?xml version="1.0" encoding="UTF-8"?>
<?mso-application progid="Excel.Sheet"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="html" indent="yes" encoding="utf-8" omit-xml-declaration="yes"/>

<xsl:variable name="tab" select="'&#09;'" />

 <xsl:template match="SetupSheetData/ReportHeading">
  <Workbook>
    <meta http-equiv="X-UA-Compatible" content="IE=EmulateIE9" />
   <head>
    <basefont face="Verdana"/>
   </head>
   <body>
    <BR/>
     <TABLE align="center">
       <TR align="center">
         <TD style="FONT: 23pt Times">
           <B>SOLIDWORKS CAM (Powered by CAMWorks)</B>
         </TD>
       </TR>

    <xsl:for-each select="./Heading">
      <TR  align="center">
        <TD style="FONT: 23pt Times">
          <xsl:value-of select="."/>
        </TD>
      </TR>
    </xsl:for-each>

     </TABLE>
     <BR/><HR SIZE="1" COLOR="#6E0204"/>
   </body>
  </Workbook>
 </xsl:template>

<xsl:template match="SetupSheetData/Data">
  <Workbook>
	  <STYLE>
		  BODY
		  {
		  BACKGROUND-POSITION: right bottom;
		  BACKGROUND-ATTACHMENT: fixed;
		  MARGIN-LEFT: 10pt;
		  background-color:#ffffff;
		  BACKGROUND-REPEAT: no-repeat;
		  }

		  .WIPImg
		  {
		  BORDER-RIGHT:#e0dee3  1px solid;
		  BORDER-TOP:#e0dee3  1px solid;
		  BORDER-LEFT:#e0dee3  1px solid;
		  BORDER-BOTTOM:#e0dee3  1px solid;
		  BORDER-COLOR: #e0dee3;
		  CURSOR: hand;
		  }

		  .WIPImgMouseOver
		  {
		  BORDER-RIGHT:#6666ff  1px solid;
		  BORDER-TOP:#6666ff  1px solid;
		  BORDER-LEFT:#6666ff  1px solid;
		  BORDER-BOTTOM:#6666ff  1px solid;
		  BORDER-COLOR: #6666ff;
		  CURSOR: hand;
		  }

		  .EE
		  {
		  BORDER-RIGHT:#e0dee3  1px solid;
		  BORDER-TOP:#e0dee3  1px solid;
		  BORDER-LEFT:#e0dee3  1px solid;
		  BORDER-BOTTOM:#e0dee3  1px solid;
		  BORDER-COLLAPSE: collapse;
		  EMPTY-CELLS: show;
		  FONT: 10 pt;
		  COLOR: BLACK;
		  BORDER-COLOR: #e0dee3;
		  }
		  .EE TD
		  {
		  BORDER-TOP:#e0dee3  1px solid;
		  PADDING-RIGHT: 5px;
		  PADDING-LEFT: 5px;
		  HEIGHT: 23px;
		  FONT: 8pt verdana;
		  BORDER-COLOR: #e0dee3;
		  }

		  .EE TH
		  {
		  PADDING-RIGHT: 5px;
		  BORDER-TOP: #e0dee3 1px solid;
		  PADDING-LEFT: 5px;
		  HEIGHT: 23px;
		  font-style:strong;
		  BORDER-COLOR: #e0dee3;
		  }

		  .clsResultSummary
		  {
		  BORDER-RIGHT:#e0dee3  1px solid;
		  BORDER-TOP:#e0dee3  1px solid;
		  BORDER-LEFT:#e0dee3  1px solid;
		  BORDER-BOTTOM:#e0dee3  1px solid;
		  BORDER-COLLAPSE: collapse;
		  EMPTY-CELLS: show;
		  FONT: 8 pt;
		  COLOR: BLACK;
		  BORDER-COLOR: #e0dee3;
		  }
		  .clsResultSummary TD
		  {
		  PADDING-RIGHT: 5px;
		  BORDER-TOP: #e0dee3 1px solid;
		  PADDING-LEFT: 5px;
		  HEIGHT: 23px
		  }

		  .clsResultSummary TH
		  {
		  PADDING-RIGHT: 5px;
		  BORDER-TOP: #e0dee3 1px solid;
		  PADDING-LEFT: 5px;
		  HEIGHT: 23px;
		  font-style: strong;
		  font-family: Arial;
		  }

		  .DivCls
		  {
		  BORDER-RIGHT:#e0dee3  0px solid;
		  BORDER-TOP:#e0dee3  0px solid;
		  BORDER-LEFT:#e0dee3  0px solid;
		  BORDER-BOTTOM:#e0dee3  0px solid;
		  BORDER-COLLAPSE: collapse;
		  EMPTY-CELLS: show;
		  COLOR: BLACK;
		  BORDER-COLOR: #e0dee3;
		  }
		  .DivCls TD
		  {
		  PADDING-RIGHT: 0px;
		  PADDING-LEFT: 0px;
		  PADDING-TOP: 0px;
		  PADDING-BOTTOM: 0px;
		  }

		  .DivCls TH
		  {
		  PADDING-RIGHT: 0px;
		  PADDING-LEFT: 0px;
		  PADDING-TOP: 0px;
		  PADDING-BOTTOM: 0px;
		  }


	</STYLE>
  
   <body>   
   <BR/><font color="#01106D" size="5"><B></B></font><BR/>
      <table border="0" align="center">

	  <tr>
          <td>
          <table class="clsResultSummary" border="1" align="Left" CELLPADDING="5">
    <xsl:for-each select="*">
    
      <xsl:if test="name() = 'rep_CustomInfo'">	
	 <tr>
	    <td>Company</td>
	    <td><xsl:value-of select="@CustomInfoCompanyName"/></td>
         </tr>
      </xsl:if> 	     
    
      <xsl:if test="name() = 'rep_CustomInfo'"> 
        <tr>    
  	 <td>Date/Time</td>
	 <td><xsl:value-of select="@CustomInfoDateTime"/></td>
	</tr>
      </xsl:if> 
    

      <xsl:if test="name() = 'rep_TurnWorkPiece'"> 
        <tr>
	 <td>Material</td>
	 <td><xsl:value-of select="@WorkPieceMaterial"/></td>
       </tr>
      </xsl:if>    
           

      <xsl:if test="name() = 'rep_CustomInfo'">	
	 <tr>
	    <td>Part File</td>
	    <td><xsl:value-of select="@CustomInfoPartFile"/></td>
         </tr>
      </xsl:if> 	   

    </xsl:for-each>      
    </table>

<!--Table for SOLIDWORKS DATA and related stuff-->
	<table class="clsResultSummary" border="1" align="Left" CELLPADDING="5">

    <xsl:for-each select="*">
	
	 <xsl:if test="name() = 'rep_CustomInfo'">	
	 <tr>
	    <td>Author</td>
	    <td><xsl:value-of select="@CustomInfoAuthor"/></td>
         </tr>
      </xsl:if>	
        
	 <xsl:if test="name() = 'rep_CustomInfo'">
	<tr>
	    <td>Keywords</td>
	    <td><xsl:value-of select="@CustomInfoKeywords"/></td>
         </tr>
      </xsl:if>

	 <xsl:if test="name() = 'rep_CustomInfo'">
	<tr>
	    <td>Comments</td>
	    <td><xsl:value-of select="@CustomInfoComments"/></td>
         </tr>
      </xsl:if>
	  
	 <xsl:if test="name() = 'rep_CustomInfo'">
	<tr>
	    <td>Title</td>
	    <td><xsl:value-of select="@CustomInfoTitle"/></td>
         </tr>
      </xsl:if>
  	  
    
    </xsl:for-each>      
    </table>
	
 <!--Table for Part File and related stuff-->
   <table class="clsResultSummary" border="1" align="Left" CELLPADDING="5">  

    <xsl:for-each select="*"> 
         
      <xsl:if test="name() = 'rep_TurnMachine'"> 
        <tr>    
  	 <td>CNC Mach</td>
	 <td><xsl:value-of select="@MchName"/></td>
	</tr>
      </xsl:if> 
    
      <xsl:if test="name() = 'rep_CustomInfo'"> 
        <tr>
	 <td>Programmer</td>
	 <td><xsl:value-of select="@notknown"/></td>
       </tr>
      </xsl:if> 

      <xsl:if test="name() = 'rep_Doc'"> 
        <tr>
	 <td>Units</td>
	 <td><xsl:value-of select="@Unit"/></td>
       </tr>
      </xsl:if>
	  
	  
	 <xsl:if test="name() = 'rep_CustomInfo'">
	<tr>
	    <td>Subject</td>
	    <td><xsl:value-of select="@CustomInfoSubject"/></td>
         </tr>
      </xsl:if>
    
    </xsl:for-each>      
    </table>
	
	
	</td>

            </tr>
        </table>
<!--End of Table for PartFile and related stuff-->
<!--Gap between header info and operation related info-->

<BR></BR>
<BR/><HR SIZE="3"/>	 
<BR></BR>
<!--Gap between header info and operation related info-->	

<!--End of Table for PartFile and related stuff-->




 <xsl:for-each select="*">	 
           
      <xsl:if test="name() = 'TurnSetupSheetAttr'"> 
	<xsl:for-each select="*">

	<xsl:if test="name() = 'rep_TurnSetupAttr'"> 	<!--if tag is rep_TurnSetupAttr -->	
	 <table class="clsResultSummary" border="1" align="center" CELLPADDING="5" width="80%" bgcolor="#FFFFD6">
	  <tr>
		<th>Setup No.</th>
		<th>Setup Name</th>
		<th>Mach Time(MIN)</th>
	  </tr>
	  <tr align="center">	   
	   <td><xsl:value-of select="@SetupAttrSetupNo"/> </td>
	   <td><xsl:value-of select="@SetupAttrSetupName"/></td>
	   <td><xsl:value-of select="@SetupAttrMachTime"/> </td>
	  </tr>
	 </table>
	</xsl:if>	<!--end if tag is rep_TurnSetupAttr -->

	<!--Give some breaks to arrange setup sheet attribute tables -->
	
		
	<!--End  - Give some breaks to arrange setup sheet attribute tables -->

		<xsl:if test="name() = 'SubSpindleOperation'">

	<BR></BR>
	<BR></BR>
	   <!--Details of the Sub Spindle Oprations-->
		 <table style="BORDER-COLLAPSE: collapse;" align="center" border="1" bordercolor="gray">
				<tr>
                  <td>
					<BR></BR>
					<table class="clsResultSummary" width="1085" height="100%" border="1" align="Left" CELLPADDING="3"> 
						<xsl:for-each select="*">	

							  <xsl:if test="name() = 'rep_Operation'"> 	
							<tr>    
							 <td>Operation</td>
							 <td colspan = "2">   <xsl:value-of 			select="@OperationName"/> </td>
							 </tr> 		   
							 <tr>
							 <td>Comment</td>
							 <td colspan = "2">  <xsl:value-of 			select="@Comment"/> </td>		 
							 </tr>
							  </xsl:if>
							  
							</xsl:for-each> <!--for each tag under SubSpindleOperation--> 
					</table>
					
					
					
					</td>
				</tr>
			</table>	
		</xsl:if> 
		
	  <xsl:if test="name() = 'TurnOperation'">

	   <!--Details of the turn Oprations-->
		
		
		
             <!-- <BR></BR>-->
              
              <BR></BR>
              <BR></BR>
              <table style="BORDER-COLLAPSE: collapse;" align="center" border="1" bordercolor="gray">
				<tr>
                  <td>
					<table class="clsResultSummary" width="400" height="100%" border="1" align="Left" CELLPADDING="3">
						<xsl:for-each select="*">	

						  <xsl:if test="name() = 'rep_Tool'"> 	
					<tr>    
					 <td>Tool Station No.</td>
					 <td colspan = "2"> <xsl:value-of 						select="@ToolStnNo"/> </td>
					</tr> 		   
					  </xsl:if>
					
					  <xsl:if test="name() = 'rep_Operation'"> 	
					<tr>    
					 <td>Operation</td>
					 <td colspan = "2">  <xsl:value-of 			select="@OperationName"/> </td>
					</tr> 		   
					  </xsl:if>
					  
					<xsl:if test="name() = 'rep_Operation'"> 	
					<tr>    
					 <td>Operation Desc</td>
					 <td colspan = "2"> <xsl:value-of 			select="@Description"/> </td>
					</tr> 		   
					  </xsl:if>

					
					  <xsl:if test="name() = 'rep_TurnTool'"> 
						  <tr>
						   <td>Insert</td>
					   <td colspan = "2"><xsl:value-of 					select="@TurnInsertSummary"/></td>
						  </tr>
						  </xsl:if> 

						  <xsl:if test="name() = 'rep_TurnTool'"> 
					   <tr>
						<td>Holder</td>
						 <td colspan = "2"><xsl:value-of 					select="@TurnHolderSummary"/></td>
					   </tr>
					  </xsl:if> 

					<xsl:if test="name() = 'rep_MillHolderLibrary'"> 
					   <tr>
						<td>Holder</td>
						 <td colspan = "2"><xsl:value-of 					select="@HolderComment"/></td>
					   </tr>
					  </xsl:if>
					  
				
						  <xsl:if test="name() = 'rep_TurnOperParams'"> 
						<tr>
						  <td>Speed</td>
						  <td><xsl:value-of 			select="@TurnOperationSpindleSpeed"/></td>
						  <td><xsl:value-of 			select="@TurnOperationSpindleMode"/> </td>
						 </tr>
						  </xsl:if>   

					  <xsl:if test="name() = 'rep_TurnOperParams'"> 
						 <tr>
						  <td>Feed</td>
						  <td><xsl:value-of 			select="@TurnOperationFeedRate"/> </td>
						  <td><xsl:value-of 			select="@TurnOperationFeedType"/> </td>
							 </tr>
						   </xsl:if>    
						  
					<xsl:if test="name() = 'rep_Relation'"> 
					 <tr>
					  <td>Time(MIN)</td>
					  <td colspan = "2">  <xsl:value-of select="@RelationTime"/></td>
					 </tr>
					</xsl:if>  

				<xsl:if test="name() = 'rep_Relation'"> 
					 <tr>
					  <td>Tlp Len</td>
					  <td colspan = "2"> <xsl:value-of select="@RelationTlpLen"/> </td>
					 </tr>
					</xsl:if>

          <xsl:if test="name() = 'rep_TurnOperParams'">
            <tr>
              <td>Spindle Direction</td>
              <td colspan = "2">
                <xsl:value-of select="@TurnOperationSpindleDir"/>
              </td>
            </tr>
          </xsl:if>
              
					</xsl:for-each> <!--for each tag under TurnOperation--> 
					</table>
				
				  <!--End of Details of the Oprations tables-->

			 <!--for the gap between image and operation parameters-->
			<!--&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;-->

			</td><td>

			<!--ADD IMAGE TO THE SETUP SHEET -->
				<xsl:for-each select="*">	
				<xsl:if test="name() = 'rep_Operation'"> 

				<xsl:variable name = "imageUrl">
				<xsl:value-of select="@ImagePath"/>
				</xsl:variable>
				
				<!--    <xsl:if test="$imageUrl !=''">-->
					<xsl:text disable-output-escaping="yes">&lt;img src="</xsl:text>
					<xsl:value-of select="$imageUrl"/>
					<xsl:text disable-output-escaping="yes">"&#160;WIDTH="400" HEIGHT="400" /&gt;</xsl:text>
				<!--    </xsl:if>-->
			 
				</xsl:if>
				</xsl:for-each>
			  <xsl:for-each select="*">
				<xsl:if test="name() = 'rep_ToolImagePath'">
				  <xsl:variable name = "imageUrl">
					<xsl:value-of select="@ToolImagePath"/>
				  </xsl:variable>
				  <xsl:if test="$imageUrl !=''">
								<xsl:text disable-output-escaping="yes">&lt;img src="</xsl:text>
								<xsl:value-of select="$imageUrl"/>
								<xsl:text disable-output-escaping="yes">"&#160;WIDTH="75" HEIGHT="150" align="Top" hspace="100" /&gt;</xsl:text>
				  </xsl:if>
				</xsl:if>
			  </xsl:for-each>
<!--End ADD IMAGE TO THE SETUP SHEET -->

</td></tr></table>

	  </xsl:if>	<!--if Turn Operation-->
	
	</xsl:for-each> <!-- for each tag under TurnSetupSheetAttr-->

	<!-- Placing divider line between two setup sheets -->		
	<BR></BR>
          <BR></BR>
          <BR></BR>
          <BR></BR>
          <BR></BR>
          <BR></BR>
          <BR/>
          <HR SIZE="3"/>
          <BR></BR>
	<!-- End Placing divider line between two setup sheets -->
	
      </xsl:if>  <!-- if tag is TurnSetupSheetAttr --> 	

</xsl:for-each>	<!-- for each tag under data --> 

   </body>
  </Workbook>
 </xsl:template>


</xsl:stylesheet>